 function plotRegions(set,data,level)

   colorH1 = 'b';
   colorH2 = 'g';
   colorH3 = 'r';
    
        utils_Physics_Part0;
        utils_Physics_Part1;
        utils_Physics_Part2;
        utils_Physics_Part3; 
        utils_Physics_Part4;
        
        utils_Mathematics_Part0;
        utils_Mathematics_Part1;
        utils_Mathematics_Part2;
        utils_Mathematics_Part3;
        utils_Mathematics_Part4;
        
        load("dataPhysics.mat");
        load("dataMathematics.mat");
        fig1=figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','on');hold on;
       
       
        % Mathematics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,level);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % FIX ME
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        plot3(dataMathematics.pE1(:,1),dataMathematics.pE1(:,2),dataMathematics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        % Pysics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,0);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 3
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        hold on
        
        plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        % Pintamos las regiones de los deployment :)
       
        h = rectangle('Position',[14.5 1 68.1 26.5],'Curvature',0.2,'EdgeColor','r','LineWidth',3) 
        aa = line(NaN,NaN,'LineWidth',2,'LineStyle','-','Color','r');
       
        h = rectangle('Position',[12.5 0 72.1 29],'Curvature',0.2,'EdgeColor','g','LineWidth',3) 
        bb = line(NaN,NaN,'LineWidth',2,'LineStyle','-','Color','g');
        
        h = rectangle('Position',[-3.5 -1 90 92],'Curvature',0.1,'EdgeColor','b','LineWidth',3) 
        cc = line(NaN,NaN,'LineWidth',2,'LineStyle','-','Color','b');
        
        text(40,32,'Physics departaments','FontSize',15,'FontName', 'Times New Roman')
        text(23,58,'Mathematics departaments','Rotation',21,'FontSize',15,'FontName', 'Times New Roman')
        
   
        legend([aa,bb,cc],'Deployment 1','Deployment 2','Deployment 3','FontSize',35,'FontName', 'Times New Roman','Position',[0.7 0.7 0.1 0.1]);
        xlim([-10 90])
        ylim([-10 100])
        hold off 
        xticks([-10:10:90]);
        yticks([-10:10:100]);     
        
        % Labels and title
        xlabel("West - East (m)",'FontSize',20,'FontName', 'Times New Roman');
        ylabel("South - North (m)",'FontSize',20,'FontName', 'Times New Roman');
        zlabel("Height (m)",'FontSize',20,'FontName', 'Times New Roman');
        % title(strcat("Physics department building - Floor:", num2str(level)," Deployment: ",num2str(set.id)));
        
        hold off
        %old_sdf(fig1,'2019_Sensors')
        daspect([1 1 1])
        fig1.Renderer = 'Painters'
        print(fig1,strcat("figures/regions.pdf"),'-dpdf');
        
        
 end